/**************************************************************************************

   Copyright (c) Hilscher GmbH. All Rights Reserved.

 **************************************************************************************

   Filename:
    $Workfile: CanOpenSlave_Public.h $
   Last Modification:
    $Author: Eric $
    $Modtime: 18.08.09 10:00 $
    $Revision: 1 $

   Targets:
    Win32/ANSI   : no
    Win32/Unicode: no (define _UNICODE)
    WinCE        : yes
    rcX          : yes

   Description:

    CanOpen Slave
    public

   Changes:

     Version    Date        Author
        Description
     ----------------------------------------------------------------------------------
           
**************************************************************************************/
/**
 * @file CanOpenSlave_Public.h
 *  CanOpen Slave - public definition of task
 *
 * The header contains the public definition of task.
 * It has to be included by another task to get access of task specfic definition.
 */
#ifndef __CANOPEN_SLAVE_PUBLIC_H
#define __CANOPEN_SLAVE_PUBLIC_H

/* pragma pack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_PACK_1(__CANOPEN_SLAVE_PUBLIC)
#endif


/*************************************************************************************/
/*------------------ Command definitions --------------------------------------------*/
/*************************************************************************************/
#define CANOPEN_SLAVE_REGISTER_REQ                0x00002900
#define CANOPEN_SLAVE_REGISTER_CNF                0x00002901

#define CANOPEN_SLAVE_STARTSTOP_REQ               0x00002902
#define CANOPEN_SLAVE_STARTSTOP_CNF               0x00002903

#define CANOPEN_SLAVE_INITIALIZE_REQ              0x00002904
#define CANOPEN_SLAVE_INITIALIZE_CNF              0x00002905

#define CANOPEN_SLAVE_EXCHANGE_DATA_REQ           0x0000290A
#define CANOPEN_SLAVE_EXCHANGE_DATA_CNF           0x0000290B

#define CANOPEN_SLAVE_STATE_CHANGE_IND            0x00002912
#define CANOPEN_SLAVE_STATE_CHANGE_RES            0x00002913

#define CANOPEN_SLAVE_SEND_EMCY_REQ               0x00002918
#define CANOPEN_SLAVE_SEND_EMCY_CNF               0x00002919

#define CANOPEN_SLAVE_SET_NMT_STATE_REQ           0x0000291A
#define CANOPEN_SLAVE_SET_NMT_STATE_CNF           0x0000291B

#define CANOPEN_SLAVE_SET_BUSPARAM_REQ            0x0000291C
#define CANOPEN_SLAVE_SET_BUSPARAM_CNF            0x0000291D

#define CANOPEN_SLAVE_SEND_TIME_STAMP_REQ         0x0000291E
#define CANOPEN_SLAVE_SEND_TIME_STAMP_CNF         0x0000291F

#define CANOPEN_SLAVE_RECV_TIME_STAMP_IND         0x00002920
#define CANOPEN_SLAVE_RECV_TIME_STAMP_RES         0x00002921

#define CANOPEN_SLAVE_SEND_TXPDO_REQ              0x00002922
#define CANOPEN_SLAVE_SEND_TXPDO_CNF              0x00002923

#define CANOPEN_SLAVE_RECV_RXPDO_REQ              0x00002924
#define CANOPEN_SLAVE_RECV_RXPDO_CNF              0x00002925

#define CANOPEN_SLAVE_RECV_RXPDO_IND              0x00002926
#define CANOPEN_SLAVE_RECV_RXPDO_RES              0x00002927

#define CANOPEN_SLAVE_SET_EVENTS_INDICATED_REQ    0x00002928
#define CANOPEN_SLAVE_SET_EVENTS_INDICATED_CNF    0x00002929

#define CANOPEN_SLAVE_GET_IO_INFO_REQ             0x0000292A
#define CANOPEN_SLAVE_GET_IO_INFO_CNF             0x0000292B

#define CANOPEN_SLAVE_SET_API_PARAM_REQ           0x0000292C
#define CANOPEN_SLAVE_SET_API_PARAM_CNF           0x0000292D

#define CANOPEN_SLAVE_NMT_STATE_CHANGE_IND        0x0000292E
#define CANOPEN_SLAVE_NMT_STATE_CHANGE_RES        0x0000292F

#define CANOPEN_SLAVE_ERR_CTRL_EVENT_IND          0x00002930
#define CANOPEN_SLAVE_ERR_CTRL_EVENT_RES          0x00002931

#define CANOPEN_SLAVE_NMT_COMMAND_IND             0x00002932
#define CANOPEN_SLAVE_NMT_COMMAND_RES             0x00002933

#define CANOPEN_SLAVE_GET_BUSPARAM_REQ            0x00002934
#define CANOPEN_SLAVE_GET_BUSPARAM_CNF            0x00002935

#define CANOPEN_SLAVE_SEND_EMCY_IND               0x00002938
#define CANOPEN_SLAVE_SEND_EMCY_RES               0x00002939

#define CANOPEN_SLAVE_SET_WATCHDOG_FAIL_REQ       0x000029AA
#define CANOPEN_SLAVE_SET_WATCHDOG_FAIL_CNF       0x000029AB

#define CANOPEN_SLAVE_SETUP_PDO_INDICATION_REQ    0x000029BA  
#define CANOPEN_SLAVE_SETUP_PDO_INDICATION_CNF    0x000029BB

#define CANOPEN_SLAVE_RECEIVE_PDO_IND             0x000029BC 
#define CANOPEN_SLAVE_RECEIVE_PDO_RES             0x000029BD
/*************************************************************************************/
/*************************************************************************************/
/*************************************************************************************/

/*---- Send and receive definitions -----------------*/
#define CANOPEN_SLAVE_SEND_OBJECT_CNT         4

#define CANOPEN_SLAVE_MIN_SEND_IDX            0x2000
#define CANOPEN_SLAVE_MAX_SEND_IDX            0x2003

#define CANOPEN_SLAVE_MIN_SEND_SUB_IDX        1
#define CANOPEN_SLAVE_DEF_SEND_SUB_IDX        128
#define CANOPEN_SLAVE_MAX_SEND_SUB_IDX        255

#define CANOPEN_SLAVE_RECV_OBJECT_CNT         4

#define CANOPEN_SLAVE_MIN_RECV_IDX            0x2200
#define CANOPEN_SLAVE_MAX_RECV_IDX            0x2203

#define CANOPEN_SLAVE_MIN_RECV_SUB_IDX        1
#define CANOPEN_SLAVE_DEF_RECV_SUB_IDX        128
#define CANOPEN_SLAVE_MAX_RECV_SUB_IDX        255
/*---------------------------------------------------*/

/*------ Data types  --------------------------------*/
#define CANOPEN_SLAVE_DATATYPE_BOOLEAN         0x0001
#define CANOPEN_SLAVE_DATATYPE_INTEGER8        0x0002
#define CANOPEN_SLAVE_DATATYPE_INTEGER16       0x0003
#define CANOPEN_SLAVE_DATATYPE_INTEGER32       0x0004
#define CANOPEN_SLAVE_DATATYPE_UNSIGNED8       0x0005
#define CANOPEN_SLAVE_DATATYPE_UNSIGNED16      0x0006
#define CANOPEN_SLAVE_DATATYPE_UNSIGNED32      0x0007
#define CANOPEN_SLAVE_DATATYPE_REAL32          0x0008
#define CANOPEN_SLAVE_DATATYPE_VISIBLE_STRING  0x0009
#define CANOPEN_SLAVE_DATATYPE_OCTET_STRING    0x000A
#define CANOPEN_SLAVE_DATATYPE_UNICODE_STRING  0x000B
#define CANOPEN_SLAVE_DATATYPE_TIME_OF_DAY     0x000C
#define CANOPEN_SLAVE_DATATYPE_TIME_DIFFERENCE 0x000D
#define CANOPEN_SLAVE_DATATYPE_DOMAIN          0x000F
#define CANOPEN_SLAVE_DATATYPE_INTEGER24       0x0010
#define CANOPEN_SLAVE_DATATYPE_REAL64          0x0011
#define CANOPEN_SLAVE_DATATYPE_INTEGER40       0x0012
#define CANOPEN_SLAVE_DATATYPE_INTEGER48       0x0013
#define CANOPEN_SLAVE_DATATYPE_INTEGER56       0x0014
#define CANOPEN_SLAVE_DATATYPE_INTEGER64       0x0015
#define CANOPEN_SLAVE_DATATYPE_UNSIGNED24      0x0016
#define CANOPEN_SLAVE_DATATYPE_UNSIGNED40      0x0018
#define CANOPEN_SLAVE_DATATYPE_UNSIGNED48      0x0019
#define CANOPEN_SLAVE_DATATYPE_UNSIGNED56      0x001A
#define CANOPEN_SLAVE_DATATYPE_UNSIGNED64      0x001B
/*---------------------------------------------------*/

/*------ Object codes -------------------------------*/
#define CANOPEN_SLAVE_OBJECT_CODE_NULL         0x00
#define CANOPEN_SLAVE_OBJECT_CODE_DOMAIN       0x02
#define CANOPEN_SLAVE_OBJECT_CODE_DEFTYPE      0x05
#define CANOPEN_SLAVE_OBJECT_CODE_DEFSTRUCT    0x06
#define CANOPEN_SLAVE_OBJECT_CODE_VAR          0x07
#define CANOPEN_SLAVE_OBJECT_CODE_ARRAY        0x08
#define CANOPEN_SLAVE_OBJECT_CODE_RECORD       0x09
/*---------------------------------------------------*/

/*------- Access rights -----------------------------*/
#define CANOPEN_SLAVE_ACCESS_READ              0x0001
#define CANOPEN_SLAVE_ACCESS_WRITE             0x0008
#define CANOPEN_SLAVE_ACCESS_READ_WRITE \
  (CANOPEN_SLAVE_ACCESS_READ |          \
   CANOPEN_SLAVE_ACCESS_WRITE)
/*---------------------------------------------------*/

/*-------------------------------------------------------------
 * NMT states for CANOPEN SLAVE SET NMT STATE REQ,
 * CANOPEN SLAVE NMT STATE CHANGE IND and
 * CANOPEN SLAVE NMT COMMAND IND
 --------------------------------------------------------------*/
#define CANOPEN_SLAVE_NMT_STATE_OPERATIONAL       0x01
#define CANOPEN_SLAVE_NMT_STATE_STOP              0x02
#define CANOPEN_SLAVE_NMT_STATE_PRE_OPERATIONAL   0x80
#define CANOPEN_SLAVE_NMT_STATE_RESET_NODE        0x81
#define CANOPEN_SLAVE_NMT_STATE_RESET_COMM        0x82
/*-------------------------------------------------------------*/

/*---------------------------------------------------------------------------------*/
/*
** Definitions for CANopen Slave task, must be
** added to TLR_Header Files
*/
/*************************************************************************************/
/** @name Queue Name
 *
 * Use the queue name to identify the process queue of task 'CanOpen Slave'.
 * Example for internal identification:<br>
 * @code
 * TLR_RESULT eRslt;
 * TLR_HANDLE hQue;
 * TLR_UINT   uiInstance = 0;
 *
 * eRslt = TLR_QUE_IDENTIFY_INTERN(
 *                                 CANOPEN_SLAVE_QUEUE_NAME,
 *                                 uiInstance,
 *                                 &hQue
 *                                 );
 * @endcode
 * <br>
 * Example for external or normal identification:<br>
 * @code
 * TLR_RESULT      eRslt;
 * TLR_QUE_LINK_T  tQue;
 * TLR_UINT        uiInstance = 0;
 *
 * eRslt = TLR_QUE_IDENTIFY(CANOPEN_SLAVE_QUEUE_NAME, uiInstance, &tQue);
 * @endcode
 * <br>
 * @{
 */
/** queue name */
#define CANOPEN_SLAVE_QUEUE_NAME      "QUE_CANOPENSLV"
#define CANOPEN_SLAVE_QUEUE_ODV3_NAME "QUE_COS_ODV3"

/** @} */

/*************************************************************************************/
/* structures */


/** @name Structure Definition
 *
 * The following defined structures are used for packet commands
 * of the several services, which are supported by the task.
 * @{
 */

/*************************************************************************************/
/** type of <code>CANOPEN_SLAVE_SLAVE_STATE_Ttag</code> */
typedef struct CANOPEN_SLAVE_SLAVE_STATE_Ttag
  CANOPEN_SLAVE_SLAVE_STATE_T;

#define CANOPEN_SLAVE_CAN_STATE_UNKNOWN         0x00000000L
#define CANOPEN_SLAVE_CAN_STATE_NOT_CONFIGURED  0x00000001L
#define CANOPEN_SLAVE_CAN_STATE_STOPPED         0x00000002L
#define CANOPEN_SLAVE_CAN_STATE_STARTED         0x00000003L
#define CANOPEN_SLAVE_CAN_STATE_RUNNING         0x00000004L

#define CANOPEN_SLAVE_STATE_FLAG_RDY            0x00000001L
#define CANOPEN_SLAVE_STATE_FLAG_RUN            0x00000002L
#define CANOPEN_SLAVE_STATE_FLAG_COM            0x00000004L
#define CANOPEN_SLAVE_STATE_FLAG_BUS_ON         0x00000008L
#define CANOPEN_SLAVE_STATE_FLAG_COMM_ERROR     0x00000010L
#define CANOPEN_SLAVE_STATE_FLAG_CAN_STARTED    0x00000100L

__PACKED_PRE struct CANOPEN_SLAVE_SLAVE_STATE_Ttag
{
  TLR_UINT32  ulCanState;

  TLR_UINT32  aulUnused[2];

  TLR_UINT32  ulFlags;

  TLR_UINT32  ulErrorCount;
  TLR_UINT32  ulCommError;

  TLR_UINT32  ulRunLedState;
  TLR_UINT32  ulErrLedState;
                              
  TLR_UINT32  ulRecvDataCnt;
  TLR_UINT32  ulSendDataCnt;
  
  TLR_UINT32  ulReserved;

}__PACKED_POST;

/*************************************************************************************/
/** type of <code>CANOPEN_SLAVE_EXTENDED_STATE_Ttag</code> */
typedef struct CANOPEN_SLAVE_EXTENDED_STATE_Ttag
  CANOPEN_SLAVE_EXTENDED_STATE_T;

#define CANOPEN_SLAVE_EXT_STATE_FLAG_CAN_INIT     0x00000001L
#define CANOPEN_SLAVE_EXT_STATE_FLAG_CAN_ACTIVE   0x00000002L
#define CANOPEN_SLAVE_EXT_STATE_FLAG_PASSIVE      0x00000004L
#define CANOPEN_SLAVE_EXT_STATE_FLAG_BUS_OFF      0x00000008L

#define CANOPEN_SLAVE_EXT_STATE_FLAG_RX_OVERFLOW  0x00000010L
#define CANOPEN_SLAVE_EXT_STATE_FLAG_TX_OVERFLOW  0x00000020L
#define CANOPEN_SLAVE_EXT_STATE_FLAG_IND_LOST     0x00000040L

#define CANOPEN_SLAVE_EXT_STATE_FLAG_WDG          0x00000100L
#define CANOPEN_SLAVE_EXT_STATE_FLAG_SLAVE_ERROR  0x00000200L

#define CANOPEN_SLAVE_EXT_STATE_CTRL              0x00001000L
#define CANOPEN_SLAVE_EXT_STATE_NRDY              0x00002000L
#define CANOPEN_SLAVE_EXT_STATE_TIMEOUT           0x00004000L

#define CANOPEN_SLAVE_EXT_STATE_FLAG_WARNING      0x00010000L

#define CANOPEN_SLAVE_EXT_STATE_UNKNOWN           0x00000000L
#define CANOPEN_SLAVE_EXT_STATE_OPERATIONAL       0x00000001L
#define CANOPEN_SLAVE_EXT_STATE_STOP              0x00000002L
#define CANOPEN_SLAVE_EXT_STATE_PRE_OPERATIONAL   0x00000080L
#define CANOPEN_SLAVE_EXT_STATE_INITIALISING      0x000000FFL

#define CANOPEN_SLAVE_ADD_DETAIL_SIZE             0x00000003L

__PACKED_PRE struct CANOPEN_SLAVE_EXTENDED_STATE_Ttag
{
  TLR_UINT32 ulFlags;
  TLR_UINT32 ulNodeState;
  TLR_UINT32 ulBusOffEveCnt;
  TLR_UINT32 ulErrorPassiveEveCnt;
  TLR_UINT32 ulRxOverflowCnt;
  TLR_UINT32 ulTxOverflowCnt;
  TLR_UINT32 ulErrorWarningCnt;
  TLR_UINT32 ulTimeoutCnt;

  TLR_UINT32 aulReserved[3];
  TLR_UINT32 ulIndLostCnt;

  TLR_UINT32 ulDiagInfoCount;
  TLR_UINT32 ulLastDiagInfo;
  TLR_UINT32 ulMaxRecvIdx;
  TLR_UINT32 ulMaxSendIdx;
  TLR_UINT32 aulAddDetail[CANOPEN_SLAVE_ADD_DETAIL_SIZE];

}__PACKED_POST;

/*************************************************************************************/


/* packets */


/** @name Packet Data Definition
 *
 * The following defined structures represent the specific parameter
 * of the several services, which are supported by the task.
 * @{
 */

/*************************************************************************************/
/** type of <code>CANOPEN_SLAVE_REGISTER_REQ_DATA_Ttag</code> */
typedef struct CANOPEN_SLAVE_REGISTER_REQ_DATA_Ttag
  CANOPEN_SLAVE_REGISTER_REQ_DATA_T;
/** type of <code>CANOPEN_SLAVE_REGISTER_CNF_DATA_Ttag</code> */
typedef struct CANOPEN_SLAVE_REGISTER_CNF_DATA_Ttag
  CANOPEN_SLAVE_REGISTER_CNF_DATA_T;

__PACKED_PRE struct CANOPEN_SLAVE_REGISTER_REQ_DATA_Ttag
{
  TLR_UINT8 bReserved; /* Reserved for further use, set to zero*/

}__PACKED_POST;

__PACKED_PRE struct CANOPEN_SLAVE_REGISTER_CNF_DATA_Ttag
{
  TLR_UINT8 bReserved; /* Reserved for further use */

}__PACKED_POST;

/*************************************************************************************/
/** type of <code>CANOPEN_SLAVE_EXCHANGE_DATA_REQ_DATA_Ttag</code> */
typedef struct CANOPEN_SLAVE_EXCHANGE_DATA_REQ_DATA_Ttag
  CANOPEN_SLAVE_EXCHANGE_DATA_REQ_DATA_T;
/** type of <code>CANOPEN_SLAVE_EXCHANGE_DATA_CNF_DATA_Ttag</code> */
typedef struct CANOPEN_SLAVE_EXCHANGE_DATA_CNF_DATA_Ttag
  CANOPEN_SLAVE_EXCHANGE_DATA_CNF_DATA_T;

/** Structure of task command start/stop CANopen request data */
__PACKED_PRE struct CANOPEN_SLAVE_EXCHANGE_DATA_REQ_DATA_Ttag
{
  TLR_UINT32 ulRecvIndex;     /* Object index for recv data     */
  TLR_UINT32 ulRecvSubIndex;  /* Object sub-index for recv data */
  TLR_UINT32 ulRecvDataCnt;   /* Recv data count                */

  TLR_UINT32 ulSendIndex;    /* Object index for send Data     */
  TLR_UINT32 ulSendSubIndex; /* Object sub-index for send Data */
  TLR_UINT32 ulSendDataCnt;  /* Send data count                */

  TLR_UINT8  abSendData[CANOPEN_SLAVE_MAX_SEND_SUB_IDX];

}__PACKED_POST;

/** Structure of task command start/stop CANopen confirmation data */
__PACKED_PRE struct CANOPEN_SLAVE_EXCHANGE_DATA_CNF_DATA_Ttag
{
  TLR_UINT32 ulRecvIndex;     /* Object index for recv data     */
  TLR_UINT32 ulRecvSubIndex;  /* Object sub-index for recv data */
  TLR_UINT32 ulRecvDataCnt;   /* Recv data count                */

  TLR_UINT32 ulSendIndex;    /* Object index for send Data     */
  TLR_UINT32 ulSendSubIndex; /* Object sub-index for send Data */
  TLR_UINT32 ulSendDataCnt;  /* Send data count                */

  TLR_UINT8  abRecvData[CANOPEN_SLAVE_MAX_RECV_SUB_IDX];

}__PACKED_POST;

#define CANOPEN_SLAVE_EXCHANGE_DATA_HEAD_SIZE (6 * sizeof(TLR_UINT32))

/*************************************************************************************/

/*************************************************************************************/
/** type of <code>CANOPEN_SLAVE_STARTSTOP_REQ_DATA_Ttag</code> */
typedef struct CANOPEN_SLAVE_STARTSTOP_REQ_DATA_Ttag
  CANOPEN_SLAVE_STARTSTOP_REQ_DATA_T;
/** type of <code>CANOPEN_SLAVE_STARTSTOP_CNF_DATA_Ttag</code> */
typedef struct CANOPEN_SLAVE_STARTSTOP_CNF_DATA_Ttag
  CANOPEN_SLAVE_STARTSTOP_CNF_DATA_T;

#define CANOPEN_SLAVE_STOP_CANOPEN     0x00000000L  /* Stop CANopen  */
#define CANOPEN_SLAVE_START_CANOPEN    0x00000001L  /* Start CANopen */

/** Structure of task command start/stop CANopen request data */
__PACKED_PRE struct CANOPEN_SLAVE_STARTSTOP_REQ_DATA_Ttag
{
  TLR_UINT32 ulMode; /* Start or stop CANopen */

}__PACKED_POST;

/** Structure of task command start/stop CANopen confirmation data */
__PACKED_PRE struct CANOPEN_SLAVE_STARTSTOP_CNF_DATA_Ttag
{
  TLR_UINT32 ulMode; /* Start or stop CANopen */

}__PACKED_POST;

/*************************************************************************************/

/*************************************************************************************/
/** type of <code>CANOPEN_SLAVE_INITIALIZE_REQ_DATA_Ttag</code> */
typedef struct CANOPEN_SLAVE_INITIALIZE_REQ_DATA_Ttag
  CANOPEN_SLAVE_INITIALIZE_REQ_DATA_T;
/** type of <code>CANOPEN_SLAVE_INITIALIZE_CNF_DATA_Ttag</code> */
typedef struct CANOPEN_SLAVE_INITIALIZE_CNF_DATA_Ttag
  CANOPEN_SLAVE_INITIALIZE_CNF_DATA_T;

/** Structure of task command delete configuration CANopenrequest data */
__PACKED_PRE struct CANOPEN_SLAVE_INITIALIZE_REQ_DATA_Ttag
{
  TLR_UINT32 ulReserved; /* Reserved fur further use, set to zero */

}__PACKED_POST;

/** Structure of task command delete configuration confirmation data */
__PACKED_PRE struct CANOPEN_SLAVE_INITIALIZE_CNF_DATA_Ttag
{
  TLR_UINT32 ulReserved; /* Reserved fur further use */

}__PACKED_POST;

/*************************************************************************************/

/*************************************************************************************/
/** type of <code>CANOPEN_SLAVE_STD_BUSPARAM_DATA_Ttag</code> */
typedef struct CANOPEN_SLAVE_STD_BUSPARAM_DATA_Ttag
  CANOPEN_SLAVE_STD_BUSPARAM_DATA_T;
/** type of <code>CANOPEN_SLAVE_EXT_BUSPARAM_DATA_Ttag</code> */
typedef struct CANOPEN_SLAVE_EXT_BUSPARAM_DATA_Ttag
  CANOPEN_SLAVE_EXT_BUSPARAM_DATA_T;
/** type of <code>CANOPEN_SLAVE_BUSPARAM_DATA_Ttag</code> */
typedef struct CANOPEN_SLAVE_BUSPARAM_DATA_Ttag
  CANOPEN_SLAVE_BUSPARAM_DATA_T;

/*------ Common configuration flags ---------------------------------------*/
#define CANOPEN_SLAVE_COMMON_FLAG_CFG_EXT_MODE                   0x10000000L
#define CANOPEN_SLAVE_COMMON_FLAG_CFG_HOLD_LAST_STATE            0x01000000L
#define CANOPEN_SLAVE_COMMON_FLAG_CFG_REJECT_RESTRICTED_CAN_ID   0x00100000L
#define CANOPEN_SLAVE_COMMON_FLAG_CFG_DISABLE_SEND_COS_SYNC_ACYC 0x00010000L
#define CANOPEN_SLAVE_COMMON_FLAG_CFG_DISABLE_SEND_COS_MAN_SPEC  0x00020000L
#define CANOPEN_SLAVE_COMMON_FLAG_CFG_DISABLE_SEND_COS_PROF_SPEC 0x00040000L
/*-------------------------------------------------------------------------*/

/*------ Configuration flags and for standard mode only -------------------*/
#define CANOPEN_SLAVE_STD_FLAG_CFG_VENDOR_ID                      0x00000010L
#define CANOPEN_SLAVE_STD_FLAG_CFG_PRODUCT_CODE                   0x00000020L
#define CANOPEN_SLAVE_STD_FLAG_CFG_SERIAL_NUMBER                  0x00000040L
#define CANOPEN_SLAVE_STD_FLAG_CFG_REVISION_NUMBER                0x00000080L
#define CANOPEN_SLAVE_STD_FLAG_CFG_DEVICE_TYPE                    0x00000100L
#define CANOPEN_SLAVE_STD_FLAG_CFG_OBJECT_SIZE                    0x00000200L
#define CANOPEN_SLAVE_STD_FLAG_CFG_PDO_CNT                        0x00000400L
/*-------------------------------------------------------------------------*/

/*------ Configuration flags for extended mode only -----------------------*/

/*-------------------------------------------------------------------------*/

#define CANOPEN_SLAVE_MIN_SLAVE_NODE_ID        1             /* Minimum node ID       */
#define CANOPEN_SLAVE_MAX_SLAVE_NODE_ID        127           /* Maximum node ID       */

#define CANOPEN_SLAVE_CFG_BAUD_1000            0x00000000L   /* 1MBaud                */
#define CANOPEN_SLAVE_CFG_BAUD_800             0x00000001L   /* 800kBaud              */
#define CANOPEN_SLAVE_CFG_BAUD_500             0x00000002L   /* 500kBaud              */
#define CANOPEN_SLAVE_CFG_BAUD_250             0x00000003L   /* 250kBaud              */
#define CANOPEN_SLAVE_CFG_BAUD_125             0x00000004L   /* 125kBaud              */
#define CANOPEN_SLAVE_CFG_BAUD_100             0x00000005L   /* 100kBaud              */
#define CANOPEN_SLAVE_CFG_BAUD_50              0x00000006L   /* 50kBaud               */
#define CANOPEN_SLAVE_CFG_BAUD_20              0x00000007L   /* 20kBaud               */
#define CANOPEN_SLAVE_CFG_BAUD_10              0x00000008L   /* 10kBaud               */
#define CANOPEN_SLAVE_CFG_BAUD_AUTO_DETECTION  0x000000FFL   /* Auto-Baud detection   */

#define CANOPEN_SLAVE_STD_CFG_DEF_OBJECT_SIZE  128 /* Default object size in std mode */

#define CANOPEN_SLAVE_CFG_MAX_RXPDO            256 /* Maximum number of RxPDO         */
#define CANOPEN_SLAVE_CFG_MAX_TXPDO            256 /* Maximum number of TxPDO         */

__PACKED_PRE struct CANOPEN_SLAVE_STD_BUSPARAM_DATA_Ttag
{
  TLR_UINT32 ulVendorId;       /* Vendor ID               */
  TLR_UINT32 ulProductCode;    /* Product code            */
  TLR_UINT32 ulSerialNumber;   /* Serial number           */
  TLR_UINT32 ulRevisionNumber; /* Revision number         */
  TLR_UINT32 ulDeviceType;     /* Device Type             */

  TLR_UINT8  bObject2000Size;  /* Size of object 2000     */
  TLR_UINT8  bObject2001Size;  /* Size of object 2001     */
  TLR_UINT8  bObject2002Size;  /* Size of object 2002     */
  TLR_UINT8  bObject2003Size;  /* Size of object 2003     */

  TLR_UINT8  bObject2200Size;  /* Size of object 2200     */
  TLR_UINT8  bObject2201Size;  /* Size of object 2201     */
  TLR_UINT8  bObject2202Size;  /* Size of object 2202     */
  TLR_UINT8  bObject2203Size;  /* Size of object 2203     */

  TLR_UINT16 usNumOfRxPdo;     /* Number of receive PDOs  */
  TLR_UINT16 usNumOfTxPdo;     /* Number of transmit PDOs */

  TLR_UINT32 aulReserved[2];   /* Reserved, set to zero   */

}__PACKED_POST;

__PACKED_PRE struct CANOPEN_SLAVE_EXT_BUSPARAM_DATA_Ttag
{
  TLR_UINT16 usNumOfRxPdo;     /* Number of receive PDOs  */
  TLR_UINT16 usNumOfTxPdo;     /* Number of transmit PDOs */
  TLR_UINT32 aulReserved[9];   /* Reserved, set to zero   */

}__PACKED_POST;

/** Structure of task command set bus param data */
__PACKED_PRE struct CANOPEN_SLAVE_BUSPARAM_DATA_Ttag
{
  TLR_UINT32 ulSlaveNodeId;  /* Node ID       */
  TLR_UINT32 ulBaudrate;     /* Baud-rate     */
  TLR_UINT32 ulCanOpenFlags; /* CANopen flags */

  __PACKED_PRE union
  {
    CANOPEN_SLAVE_STD_BUSPARAM_DATA_T tStdBusParam; /* Parameter for standard mode*/
    CANOPEN_SLAVE_EXT_BUSPARAM_DATA_T tExtBusParam; /* Parameter for extended mode*/

  }__PACKED_POST uMode;

  TLR_UINT32 ul29BitCode; /* 29Bit Code */
  TLR_UINT32 ul29BitMask; /* 29Bit Mask */
  
}__PACKED_POST;

/*************************************************************************************/
/** type of <code>CANOPEN_SLAVE_BUSPARAM_DATA_Ttag</code> */
typedef struct CANOPEN_SLAVE_BUSPARAM_DATA_Ttag
  CANOPEN_SLAVE_SET_BUSPARAM_REQ_DATA_T;

/*************************************************************************************/
/** type of <code>CANOPEN_SLAVE_BUSPARAM_DATA_Ttag</code> */
typedef struct CANOPEN_SLAVE_BUSPARAM_DATA_Ttag
  CANOPEN_SLAVE_GET_BUSPARAM_CNF_DATA_T;

/*************************************************************************************/
/** type of <code>CANOPEN_SLAVE_STATE_CHANGE_IND_DATA_Ttag</code> */
typedef struct CANOPEN_SLAVE_STATE_CHANGE_IND_DATA_Ttag
  CANOPEN_SLAVE_STATE_CHANGE_IND_DATA_T;

__PACKED_PRE struct CANOPEN_SLAVE_STATE_CHANGE_IND_DATA_Ttag
{
  CANOPEN_SLAVE_SLAVE_STATE_T    tSlaveState;     /* Slave state    */
  CANOPEN_SLAVE_EXTENDED_STATE_T tExtendedState;  /* Extended state */

}__PACKED_POST;

/*************************************************************************************/
#define CANOPEN_SLAVE_EMCY_DATA_SIZE 5

#define CANOPEN_SLAVE_ERROR_REGISTER_ERROR_RESET      0x00
#define CANOPEN_SLAVE_ERROR_REGISTER_GENERIC_BIT      0x01
#define CANOPEN_SLAVE_ERROR_REGISTER_CURRENT_BIT      0x02
#define CANOPEN_SLAVE_ERROR_REGISTER_VOLTAGE_BIT      0x04
#define CANOPEN_SLAVE_ERROR_REGISTER_TEMPERATURE_BIT  0x08
#define CANOPEN_SLAVE_ERROR_REGISTER_COMM_ERROR_BIT   0x10
#define CANOPEN_SLAVE_ERROR_REGISTER_DEV_PROFILE_BIT  0x20
#define CANOPEN_SLAVE_ERROR_REGISTER_RESERVED_BIT     0x40
#define CANOPEN_SLAVE_ERROR_REGISTER_MANU_SPEC_BIT    0x80

/** type of <code>CANOPEN_SLAVE_SEND_EMCY_REQ_DATA_Ttag</code> */
typedef struct CANOPEN_SLAVE_SEND_EMCY_REQ_DATA_Ttag
  CANOPEN_SLAVE_SEND_EMCY_REQ_DATA_T;

__PACKED_PRE struct CANOPEN_SLAVE_SEND_EMCY_REQ_DATA_Ttag
{
  TLR_UINT16 usErrorCode;
  TLR_UINT8  abManErrorCode[CANOPEN_SLAVE_EMCY_DATA_SIZE];
  TLR_UINT8  bErrorRegister;

}__PACKED_POST;

/** type of <code>CANOPEN_SLAVE_SEND_EMCY_IND_DATA_Ttag</code> */
typedef struct CANOPEN_SLAVE_SEND_EMCY_IND_DATA_Ttag
  CANOPEN_SLAVE_SEND_EMCY_IND_DATA_T;

__PACKED_PRE struct CANOPEN_SLAVE_SEND_EMCY_IND_DATA_Ttag
{
  TLR_UINT16 usErrorCode;
  TLR_UINT8  abManErrorCode[CANOPEN_SLAVE_EMCY_DATA_SIZE];
  TLR_UINT8  bErrorRegister;

}__PACKED_POST;

/*************************************************************************************/
/** type of <code>CANOPEN_SLAVE_SET_EVENTS_INDICATED_REQ_DATA_Ttag</code> */
typedef struct CANOPEN_SLAVE_SET_EVENTS_INDICATED_REQ_DATA_Ttag
  CANOPEN_SLAVE_SET_EVENTS_INDICATED_REQ_DATA_T;

#define CANOPEN_SLAVE_EVENT_NMT_STATE_CHANGE_MSK 0x00000001L
#define CANOPEN_SLAVE_EVENT_TIME_STAMP_MSK       0x00000002L
#define CANOPEN_SLAVE_EVENT_ERR_CTRL_MSK         0x00000004L
#define CANOPEN_SLAVE_EVENT_RECV_RXPDO_MSK       0x00000008L
#define CANOPEN_SLAVE_EVENT_NMT_COMMAND_MSK      0x00000010L
#define CANOPEN_SLAVE_EVENT_SEND_EMCY_MSK        0x00000020L
#define CANOPEN_SLAVE_EVENT_RESERVED_MSK         0xFFFFFFC0L

__PACKED_PRE struct CANOPEN_SLAVE_SET_EVENTS_INDICATED_REQ_DATA_Ttag
{
  TLR_UINT32 ulEventsIndicated;

}__PACKED_POST;

/*************************************************************************************/
/** type of <code>CANOPEN_SLAVE_GET_IO_INFO_CNF_DATA_Ttag</code> */
typedef struct CANOPEN_SLAVE_GET_IO_INFO_CNF_DATA_Ttag
  CANOPEN_SLAVE_GET_IO_INFO_CNF_DATA_T;

__PACKED_PRE struct CANOPEN_SLAVE_GET_IO_INFO_CNF_DATA_Ttag
{
  TLR_UINT32 ulRecvDataCnt;
  TLR_UINT32 ulSendDataCnt;

}__PACKED_POST;

/*************************************************************************************/
/** type of <code>CANOPEN_SLAVE_SET_API_PARAM_REQ_DATA_Ttag</code> */
typedef struct CANOPEN_SLAVE_SET_API_PARAM_REQ_DATA_Ttag
  CANOPEN_SLAVE_SET_API_PARAM_REQ_DATA_T;
/** type of <code>CANOPEN_SLAVE_SET_API_PARAM_CNF_DATA_Ttag</code> */
typedef struct CANOPEN_SLAVE_SET_API_PARAM_CNF_DATA_Ttag
  CANOPEN_SLAVE_SET_API_PARAM_CNF_DATA_T;

typedef TLR_VOID (CALLBACK FAR* PFN_CANOPEN_SLAVE_CALLBACK)
(
TLR_HANDLE hApplication
);

__PACKED_PRE struct CANOPEN_SLAVE_SET_API_PARAM_REQ_DATA_Ttag
{
  TLR_HANDLE hApplication;

  PFN_CANOPEN_SLAVE_CALLBACK pFncSendDataUpdated;
  TLR_UINT8 FAR* pbSrcData;
  TLR_UINT32 ulSrcDataCnt;

  PFN_CANOPEN_SLAVE_CALLBACK pFncRecvDataUpdated;
  TLR_UINT8 FAR* pbDstData;
  TLR_UINT32 ulDstDataCnt;

}__PACKED_POST;

__PACKED_PRE struct CANOPEN_SLAVE_SET_API_PARAM_CNF_DATA_Ttag
{
  TLR_HANDLE hSlave;

}__PACKED_POST;

/*************************************************************************************/
/** type of <code>CANOPEN_SLAVE_NMT_STATE_CHANGE_IND_DATA_Ttag</code> */
typedef struct CANOPEN_SLAVE_NMT_STATE_CHANGE_IND_DATA_Ttag
  CANOPEN_SLAVE_NMT_STATE_CHANGE_IND_DATA_T;

__PACKED_PRE struct CANOPEN_SLAVE_NMT_STATE_CHANGE_IND_DATA_Ttag
{
  TLR_UINT32 ulNmtState;

}__PACKED_POST;

/*************************************************************************************/
/** type of <code>CANOPEN_SLAVE_ERR_CTRL_EVENT_IND_DATA_Ttag</code> */
typedef struct CANOPEN_SLAVE_ERR_CTRL_EVENT_IND_DATA_Ttag
  CANOPEN_SLAVE_ERR_CTRL_EVENT_IND_DATA_T;
/** type of <code>CANOPEN_SLAVE_ERR_CTRL_EVENT_Ttag</code> */
typedef struct CANOPEN_SLAVE_ERR_CTRL_EVENT_Ttag
  CANOPEN_SLAVE_ERR_CTRL_EVENT_T;

#define CANOPEN_SLAVE_MAX_ERR_CTRL_EVENT  16

#define CANOPEN_SLAVE_HEARTBEAT_STARTED   0x00000001L
#define CANOPEN_SLAVE_HEARTBEAT_ERROR     0x00000002L
#define CANOPEN_SLAVE_HEARTBEAT_STOPPED   0x00000003L

#define CANOPEN_SLAVE_LIFE_GUARD_STARTED  0x00000004L
#define CANOPEN_SLAVE_LIFE_GUARD_ERROR    0x00000005L
#define CANOPEN_SLAVE_LIFE_GUARD_STOPPED  0x00000006L

__PACKED_PRE struct CANOPEN_SLAVE_ERR_CTRL_EVENT_Ttag
{
  TLR_UINT32 ulEvent;
  TLR_UINT32 ulNodeId;

}__PACKED_POST;

__PACKED_PRE struct CANOPEN_SLAVE_ERR_CTRL_EVENT_IND_DATA_Ttag
{
  CANOPEN_SLAVE_ERR_CTRL_EVENT_T atErrCtrlEvent[CANOPEN_SLAVE_MAX_ERR_CTRL_EVENT];

}__PACKED_POST;

/*************************************************************************************/
/** type of <code>CANOPEN_SLAVE_NMT_COMMAND_IND_DATA_Ttag</code> */
typedef struct CANOPEN_SLAVE_NMT_COMMAND_IND_DATA_Ttag
  CANOPEN_SLAVE_NMT_COMMAND_IND_DATA_T;
/** type of <code>CANOPEN_SLAVE_NMT_COMMAND_RES_DATA_Ttag</code> */
typedef struct CANOPEN_SLAVE_NMT_COMMAND_RES_DATA_Ttag
  CANOPEN_SLAVE_NMT_COMMAND_RES_DATA_T;

__PACKED_PRE struct CANOPEN_SLAVE_NMT_COMMAND_IND_DATA_Ttag
{
  TLR_UINT32 ulNmtCommand;  /* Requeset NMT command from NMT master */

}__PACKED_POST;

__PACKED_PRE struct CANOPEN_SLAVE_NMT_COMMAND_RES_DATA_Ttag
{
  TLR_UINT32 ulNmtState;  /* New local NMT state */

}__PACKED_POST;

/*************************************************************************************/
/** type of <code>CANOPEN_SLAVE_SEND_TIME_STAMP_REQ_DATA_Ttag</code> */
typedef struct CANOPEN_SLAVE_SEND_TIME_STAMP_REQ_DATA_Ttag
  CANOPEN_SLAVE_SEND_TIME_STAMP_REQ_DATA_T;

__PACKED_PRE struct CANOPEN_SLAVE_SEND_TIME_STAMP_REQ_DATA_Ttag
{
  TLR_UINT32 ulMilliseconds;
  TLR_UINT16 usDays;

}__PACKED_POST;

/*************************************************************************************/
/** type of <code>CANOPEN_SLAVE_RECV_TIME_STAMP_IND_DATA_Ttag</code> */
typedef struct CANOPEN_SLAVE_RECV_TIME_STAMP_IND_DATA_Ttag
  CANOPEN_SLAVE_RECV_TIME_STAMP_IND_DATA_T;

__PACKED_PRE struct CANOPEN_SLAVE_RECV_TIME_STAMP_IND_DATA_Ttag
{
  TLR_UINT32 ulMilliseconds;
  TLR_UINT16 usDays;

}__PACKED_POST;

/*************************************************************************************/
/** type of <code>CANOPEN_SLAVE_SEND_TXPDO_REQ_DATA_Ttag</code> */
typedef struct CANOPEN_SLAVE_SEND_TXPDO_REQ_DATA_Ttag
  CANOPEN_SLAVE_SEND_TXPDO_REQ_DATA_T;
/** type of <code>CANOPEN_SLAVE_SEND_TXPDO_CNF_DATA_Ttag</code> */
typedef struct CANOPEN_SLAVE_SEND_TXPDO_CNF_DATA_Ttag
  CANOPEN_SLAVE_SEND_TXPDO_CNF_DATA_T;

#define CANOPEN_SLAVE_SEND_TXPDO_REQ_MAX    16

__PACKED_PRE struct CANOPEN_SLAVE_SEND_TXPDO_REQ_DATA_Ttag
{
  TLR_UINT32 aulSendTxPdoNumber[CANOPEN_SLAVE_SEND_TXPDO_REQ_MAX];

}__PACKED_POST;

__PACKED_PRE struct CANOPEN_SLAVE_SEND_TXPDO_CNF_DATA_Ttag
{
  TLR_UINT32 aulSendTxPdoResult[CANOPEN_SLAVE_SEND_TXPDO_REQ_MAX];

}__PACKED_POST;

/*************************************************************************************/
/** type of <code>CANOPEN_SLAVE_RECV_RXPDO_REQ_DATA_Ttag</code> */
typedef struct CANOPEN_SLAVE_RECV_RXPDO_REQ_DATA_Ttag
  CANOPEN_SLAVE_RECV_RXPDO_REQ_DATA_T;
/** type of <code>CANOPEN_SLAVE_RECV_RXPDO_CNF_DATA_Ttag</code> */
typedef struct CANOPEN_SLAVE_RECV_RXPDO_CNF_DATA_Ttag
  CANOPEN_SLAVE_RECV_RXPDO_CNF_DATA_T;

#define CANOPEN_SLAVE_RECV_RXPDO_REQ_MAX    16

__PACKED_PRE struct CANOPEN_SLAVE_RECV_RXPDO_REQ_DATA_Ttag
{
  TLR_UINT32 aulRecvRxPdoNumber[CANOPEN_SLAVE_RECV_RXPDO_REQ_MAX];

}__PACKED_POST;

__PACKED_PRE struct CANOPEN_SLAVE_RECV_RXPDO_CNF_DATA_Ttag
{
  TLR_UINT32 aulRecvRxPdoResult[CANOPEN_SLAVE_RECV_RXPDO_REQ_MAX];

}__PACKED_POST;

/*************************************************************************************/
/** type of <code>CANOPEN_SLAVE_RECV_RXPDO_IND_DATA_Ttag</code> */
typedef struct CANOPEN_SLAVE_RECV_RXPDO_IND_DATA_Ttag
  CANOPEN_SLAVE_RECV_RXPDO_IND_DATA_T;

#define CANOPEN_SLAVE_RECV_RXPDO_IND_MAX    16

__PACKED_PRE struct CANOPEN_SLAVE_RECV_RXPDO_IND_DATA_Ttag
{
  TLR_UINT32 aulRecvRxPdoNumber[CANOPEN_SLAVE_RECV_RXPDO_IND_MAX];

}__PACKED_POST;

/*************************************************************************************/
/** type of <code>CANOPEN_SLAVE_SET_NMT_STATE_REQ_DATA_Ttag</code> */
typedef struct CANOPEN_SLAVE_SET_NMT_STATE_REQ_DATA_Ttag
  CANOPEN_SLAVE_SET_NMT_STATE_REQ_DATA_T;

/** type of <code>CANOPEN_SLAVE_SET_NMT_STATE_CNF_DATA_Ttag</code> */
typedef struct CANOPEN_SLAVE_SET_NMT_STATE_CNF_DATA_Ttag
  CANOPEN_SLAVE_SET_NMT_STATE_CNF_DATA_T;

__PACKED_PRE struct CANOPEN_SLAVE_SET_NMT_STATE_REQ_DATA_Ttag
{
  TLR_UINT32 ulNmtState;  /* NMT state */

}__PACKED_POST;

__PACKED_PRE struct CANOPEN_SLAVE_SET_NMT_STATE_CNF_DATA_Ttag
{
  TLR_UINT32 ulNmtState; /* NMT state */

}__PACKED_POST;
                  
/*************************************************************************************/
/** type of <code>CANOPEN_SLAVE_SETUP_PDO_INDICATION_REQ_DATA_Ttag</code> */
typedef struct CANOPEN_SLAVE_SETUP_PDO_INDICATION_REQ_DATA_Ttag
  CANOPEN_SLAVE_SETUP_PDO_INDICATION_REQ_DATA_T;

#define CANOPEN_SLAVE_SETUP_PDO_INDICATION_DISABLE         0x000000001L
#define CANOPEN_SLAVE_SETUP_PDO_INDICATION_ENABLE_SINGLE   0x000000002L
#define CANOPEN_SLAVE_SETUP_PDO_INDICATION_ENABLE_MULTIPLE 0x000000003L

__PACKED_PRE struct CANOPEN_SLAVE_SETUP_PDO_INDICATION_REQ_DATA_Ttag
{
  TLR_UINT32 ulSetupPdoIndication; /* Parameter for PDO indications*/

}__PACKED_POST;
 
/*************************************************************************************/
/** type of <code>CANOPEN_SLAVE_RECEIVE_PDO_IND_DATA_Ttag</code> */
typedef struct CANOPEN_SLAVE_RECEIVE_PDO_IND_DATA_Ttag
  CANOPEN_SLAVE_RECEIVE_PDO_IND_DATA_T;
/** type of <code>CANOPEN_SLAVE_PDO_DATA_Ttag</code> */
typedef struct CANOPEN_SLAVE_PDO_DATA_Ttag
  CANOPEN_SLAVE_PDO_DATA_T;

#define CANOPEN_SLAVE_RECEIVE_PDO_IND_MAX       16
#define CANOPEN_SLAVE_RECEIVE_PDO_IND_MAX_DATA  8 

__PACKED_PRE struct CANOPEN_SLAVE_PDO_DATA_Ttag
{
  TLR_UINT32 ulPdoNumber;                                       /* PDO number     */
  TLR_UINT32 ulIdentifier;                                      /* CAN identifier */
  TLR_UINT32 ulLength;                                          /* Data lenght    */
  TLR_UINT8  abPdoData[CANOPEN_SLAVE_RECEIVE_PDO_IND_MAX_DATA]; /* PDO data       */

}__PACKED_POST;

__PACKED_PRE struct CANOPEN_SLAVE_RECEIVE_PDO_IND_DATA_Ttag
{
  CANOPEN_SLAVE_PDO_DATA_T atPdoData[CANOPEN_SLAVE_RECEIVE_PDO_IND_MAX];

}__PACKED_POST;

/** @} */


/** @name Packet Definition
 *
 * The following definied structures represent the packets of the several services, which
 * are supported by the task.
 * @{
 */

/*************************************************************************************/
/** type of <code>CANOPEN_SLAVE_PACKET_REGISTER_REQ_Ttag</code> */
typedef struct CANOPEN_SLAVE_PACKET_REGISTER_REQ_Ttag
  CANOPEN_SLAVE_PACKET_REGISTER_REQ_T;
/** type of <code>CANOPEN_SLAVE_PACKET_REGISTER_CNF_Ttag</code> */
typedef struct CANOPEN_SLAVE_PACKET_REGISTER_CNF_Ttag
  CANOPEN_SLAVE_PACKET_REGISTER_CNF_T;

/** Structure of task command application register request*/
__PACKED_PRE struct CANOPEN_SLAVE_PACKET_REGISTER_REQ_Ttag
{
  TLR_PACKET_HEADER_T               tHead;  /** packet header.       */
  CANOPEN_SLAVE_REGISTER_REQ_DATA_T tData;  /** packet request data. */

}__PACKED_POST;

/** Structure of task comand application register confirmation */
__PACKED_PRE struct CANOPEN_SLAVE_PACKET_REGISTER_CNF_Ttag
{
  TLR_PACKET_HEADER_T               tHead; /** packet header.            */
  CANOPEN_SLAVE_REGISTER_CNF_DATA_T tData; /** packet confirmation data. */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>CANOPEN_SLAVE_PACKET_EXCHANGE_DATA_REQ_Ttag</code> */
typedef struct CANOPEN_SLAVE_PACKET_EXCHANGE_DATA_REQ_Ttag
  CANOPEN_SLAVE_PACKET_EXCHANGE_DATA_REQ_T;
/** type of <code>CANOPEN_SLAVE_PACKET_EXCHANGE_DATA_CNF_Ttag</code> */
typedef struct CANOPEN_SLAVE_PACKET_EXCHANGE_DATA_CNF_Ttag
  CANOPEN_SLAVE_PACKET_EXCHANGE_DATA_CNF_T;

/** Structure of task command exchange data request*/
__PACKED_PRE struct CANOPEN_SLAVE_PACKET_EXCHANGE_DATA_REQ_Ttag
{
  TLR_PACKET_HEADER_T                    tHead;   /** packet header.       */
  CANOPEN_SLAVE_EXCHANGE_DATA_REQ_DATA_T tData;  /** packet request data. */

}__PACKED_POST;

/** Structure of task comand exchange data confirmation */
__PACKED_PRE struct CANOPEN_SLAVE_PACKET_EXCHANGE_DATA_CNF_Ttag
{
  TLR_PACKET_HEADER_T                    tHead;  /** packet header.            */
  CANOPEN_SLAVE_EXCHANGE_DATA_CNF_DATA_T tData;  /** packet confirmation data. */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>CANOPEN_SLAVE_PACKET_STARTSTOP_REQ_Ttag</code> */
typedef struct CANOPEN_SLAVE_PACKET_STARTSTOP_REQ_Ttag
  CANOPEN_SLAVE_PACKET_STARTSTOP_REQ_T;
/** type of <code>CANOPEN_SLAVE_PACKET_STARTSTOP_CNF_Ttag</code> */
typedef struct CANOPEN_SLAVE_PACKET_STARTSTOP_CNF_Ttag
  CANOPEN_SLAVE_PACKET_STARTSTOP_CNF_T;

/** Structure of task command start/stop CANopen request */
__PACKED_PRE struct CANOPEN_SLAVE_PACKET_STARTSTOP_REQ_Ttag
{
  TLR_PACKET_HEADER_T                tHead;  /** packet header.       */
  CANOPEN_SLAVE_STARTSTOP_REQ_DATA_T tData;  /** packet request data. */

}__PACKED_POST;

/** Structure of task command start/stop CANopen confirmation */
__PACKED_PRE struct CANOPEN_SLAVE_PACKET_STARTSTOP_CNF_Ttag
{
  TLR_PACKET_HEADER_T                tHead;  /** packet header.            */
  CANOPEN_SLAVE_STARTSTOP_CNF_DATA_T tData;  /** packet confirmation data. */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>CANOPEN_SLAVE_PACKET_INITIALIZE_REQ_Ttag</code> */
typedef struct CANOPEN_SLAVE_PACKET_INITIALIZE_REQ_Ttag
  CANOPEN_SLAVE_PACKET_INITIALIZE_REQ_T;
/** type of <code>CANOPEN_SLAVE_PACKET_INITIALIZE_CNF_Ttag</code> */
typedef struct CANOPEN_SLAVE_PACKET_INITIALIZE_CNF_Ttag
  CANOPEN_SLAVE_PACKET_INITIALIZE_CNF_T;

/** Structure of task command delete configuration request */
__PACKED_PRE struct CANOPEN_SLAVE_PACKET_INITIALIZE_REQ_Ttag
{
  TLR_PACKET_HEADER_T                 tHead;  /** packet header.       */
  CANOPEN_SLAVE_INITIALIZE_REQ_DATA_T tData;  /** packet request data. */

}__PACKED_POST;

/** Structure of task comand delete configuration confirmation */
__PACKED_PRE struct CANOPEN_SLAVE_PACKET_INITIALIZE_CNF_Ttag
{
  TLR_PACKET_HEADER_T                 tHead;  /** packet header.            */
  CANOPEN_SLAVE_INITIALIZE_CNF_DATA_T tData;  /** packet confirmation data. */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>CANOPEN_SLAVE_PACKET_SET_BUSPARAM_REQ_Ttag</code> */
typedef struct CANOPEN_SLAVE_PACKET_SET_BUSPARAM_REQ_Ttag
  CANOPEN_SLAVE_PACKET_SET_BUSPARAM_REQ_T;
/** type of <code>CANOPEN_SLAVE_PACKET_SET_BUSPARAM_CNF_Ttag</code> */
typedef struct CANOPEN_SLAVE_PACKET_SET_BUSPARAM_CNF_Ttag
  CANOPEN_SLAVE_PACKET_SET_BUSPARAM_CNF_T;

/** Structure of task command set bus parameter request */
__PACKED_PRE struct CANOPEN_SLAVE_PACKET_SET_BUSPARAM_REQ_Ttag
{
  TLR_PACKET_HEADER_T                   tHead;  /** packet header.       */
  CANOPEN_SLAVE_SET_BUSPARAM_REQ_DATA_T tData;  /** packet request data. */

}__PACKED_POST;

/** Structure of task comand set bus parameter confirmation */
struct CANOPEN_SLAVE_PACKET_SET_BUSPARAM_CNF_Ttag
{
  TLR_PACKET_HEADER_T tHead;                    /** packet header.       */

}__PACKED_POST;
/*************************************************************************************/
/** type of <code>CANOPEN_SLAVE_PACKET_STATE_CHANGE_IND_Ttag</code> */
typedef struct CANOPEN_SLAVE_PACKET_STATE_CHANGE_IND_Ttag
  CANOPEN_SLAVE_PACKET_STATE_CHANGE_IND_T;
/** type of <code>CANOPEN_SLAVE_PACKET_STATE_CHANGE_RES_Ttag</code> */
typedef struct CANOPEN_SLAVE_PACKET_STATE_CHANGE_RES_Ttag
  CANOPEN_SLAVE_PACKET_STATE_CHANGE_RES_T;

__PACKED_PRE struct CANOPEN_SLAVE_PACKET_STATE_CHANGE_IND_Ttag
{
  TLR_PACKET_HEADER_T                   tHead;  /** packet header.            */
  CANOPEN_SLAVE_STATE_CHANGE_IND_DATA_T tData;  /** packet request data.      */

}__PACKED_POST;

__PACKED_PRE struct CANOPEN_SLAVE_PACKET_STATE_CHANGE_RES_Ttag
{
  TLR_PACKET_HEADER_T tHead;                    /** packet header.            */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>CANOPEN_SLAVE_PACKET_SEND_EMCY_REQ_Ttag</code> */
typedef struct CANOPEN_SLAVE_PACKET_SEND_EMCY_REQ_Ttag
  CANOPEN_SLAVE_PACKET_SEND_EMCY_REQ_T;
/** type of <code>CANOPEN_SLAVE_PACKET_SEND_EMCY_CNF_Ttag</code> */
typedef struct CANOPEN_SLAVE_PACKET_SEND_EMCY_CNF_Ttag
  CANOPEN_SLAVE_PACKET_SEND_EMCY_CNF_T;

__PACKED_PRE struct CANOPEN_SLAVE_PACKET_SEND_EMCY_REQ_Ttag
{
  TLR_PACKET_HEADER_T                 tHead; /** packet header.            */
  CANOPEN_SLAVE_SEND_EMCY_REQ_DATA_T  tData; /** packet request data.      */

}__PACKED_POST;

__PACKED_PRE struct CANOPEN_SLAVE_PACKET_SEND_EMCY_CNF_Ttag
{
  TLR_PACKET_HEADER_T tHead;                 /** packet header.            */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>CANOPEN_SLAVE_PACKET_SEND_EMCY_IND_Ttag</code> */
typedef struct CANOPEN_SLAVE_PACKET_SEND_EMCY_IND_Ttag
  CANOPEN_SLAVE_PACKET_SEND_EMCY_IND_T;
/** type of <code>CANOPEN_SLAVE_PACKET_SEND_EMCY_RES_Ttag</code> */
typedef struct CANOPEN_SLAVE_PACKET_SEND_EMCY_RES_Ttag
  CANOPEN_SLAVE_PACKET_SEND_EMCY_RES_T;

__PACKED_PRE struct CANOPEN_SLAVE_PACKET_SEND_EMCY_IND_Ttag
{
  TLR_PACKET_HEADER_T                 tHead; /** packet header.            */
  CANOPEN_SLAVE_SEND_EMCY_IND_DATA_T  tData; /** packet induest data.      */

}__PACKED_POST;

__PACKED_PRE struct CANOPEN_SLAVE_PACKET_SEND_EMCY_RES_Ttag
{
  TLR_PACKET_HEADER_T tHead;                 /** packet header.            */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>CANOPEN_SLAVE_PACKET_SEND_TIME_STAMP_REQ_Ttag</code> */
typedef struct CANOPEN_SLAVE_PACKET_SEND_TIME_STAMP_REQ_Ttag
  CANOPEN_SLAVE_PACKET_SEND_TIME_STAMP_REQ_T;
/** type of <code>CANOPEN_SLAVE_PACKET_SEND_TIME_STAMP_CNF_Ttag</code> */
typedef struct CANOPEN_SLAVE_PACKET_SEND_TIME_STAMP_CNF_Ttag
  CANOPEN_SLAVE_PACKET_SEND_TIME_STAMP_CNF_T;

__PACKED_PRE struct CANOPEN_SLAVE_PACKET_SEND_TIME_STAMP_REQ_Ttag
{
  TLR_PACKET_HEADER_T                       tHead; /** packet header.            */
  CANOPEN_SLAVE_SEND_TIME_STAMP_REQ_DATA_T  tData; /** packet request data.      */

}__PACKED_POST;

__PACKED_PRE struct CANOPEN_SLAVE_PACKET_SEND_TIME_STAMP_CNF_Ttag
{
  TLR_PACKET_HEADER_T tHead;                        /** packet header. */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>CANOPEN_SLAVE_PACKET_GET_IO_INFO_REQ_Ttag</code> */
typedef struct CANOPEN_SLAVE_PACKET_GET_IO_INFO_REQ_Ttag
  CANOPEN_SLAVE_PACKET_GET_IO_INFO_REQ_T;
/** type of <code>CANOPEN_SLAVE_PACKET_GET_IO_INFO_CNF_Ttag</code> */
typedef struct CANOPEN_SLAVE_PACKET_GET_IO_INFO_CNF_Ttag
  CANOPEN_SLAVE_PACKET_GET_IO_INFO_CNF_T;

__PACKED_PRE struct CANOPEN_SLAVE_PACKET_GET_IO_INFO_REQ_Ttag
{
  TLR_PACKET_HEADER_T tHead;                  /** packet header.            */

}__PACKED_POST;

__PACKED_PRE struct CANOPEN_SLAVE_PACKET_GET_IO_INFO_CNF_Ttag
{
  TLR_PACKET_HEADER_T                  tHead; /** packet header.            */
  CANOPEN_SLAVE_GET_IO_INFO_CNF_DATA_T tData; /** packet confirmation data. */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>CANOPEN_SLAVE_PACKET_SET_API_PARAM_REQ_Ttag</code> */
typedef struct CANOPEN_SLAVE_PACKET_SET_API_PARAM_REQ_Ttag
  CANOPEN_SLAVE_PACKET_SET_API_PARAM_REQ_T;
/** type of <code>CANOPEN_SLAVE_PACKET_SET_API_PARAM_CNF_Ttag</code> */
typedef struct CANOPEN_SLAVE_PACKET_SET_API_PARAM_CNF_Ttag
  CANOPEN_SLAVE_PACKET_SET_API_PARAM_CNF_T;

__PACKED_PRE struct CANOPEN_SLAVE_PACKET_SET_API_PARAM_REQ_Ttag
{
  TLR_PACKET_HEADER_T                       tHead; /** packet header.         */
  CANOPEN_SLAVE_SET_API_PARAM_REQ_DATA_T    tData; /** packet request data.   */

}__PACKED_POST;

__PACKED_PRE struct CANOPEN_SLAVE_PACKET_SET_API_PARAM_CNF_Ttag
{
  TLR_PACKET_HEADER_T                    tHead; /** packet header.            */
  CANOPEN_SLAVE_SET_API_PARAM_CNF_DATA_T tData; /** packet confirmation data. */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>CANOPEN_SLAVE_PACKET_RECV_TIME_STAMP_IND_Ttag</code> */
typedef struct CANOPEN_SLAVE_PACKET_RECV_TIME_STAMP_IND_Ttag
  CANOPEN_SLAVE_PACKET_RECV_TIME_STAMP_IND_T;
/** type of <code>CANOPEN_SLAVE_PACKET_RECV_TIME_STAMP_RES_Ttag</code> */
typedef struct CANOPEN_SLAVE_PACKET_RECV_TIME_STAMP_RES_Ttag
  CANOPEN_SLAVE_PACKET_RECV_TIME_STAMP_RES_T;

__PACKED_PRE struct CANOPEN_SLAVE_PACKET_RECV_TIME_STAMP_IND_Ttag
{
  TLR_PACKET_HEADER_T                       tHead; /** packet header.            */
  CANOPEN_SLAVE_RECV_TIME_STAMP_IND_DATA_T  tData; /** packet request data.      */

}__PACKED_POST;

__PACKED_PRE struct CANOPEN_SLAVE_PACKET_RECV_TIME_STAMP_RES_Ttag
{
  TLR_PACKET_HEADER_T tHead;                       /** packet header.             */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>CANOPEN_SLAVE_PACKET_SET_WATCHDOG_FAIL_REQ_Ttag</code> */
typedef struct CANOPEN_SLAVE_PACKET_SET_WATCHDOG_FAIL_REQ_Ttag
  CANOPEN_SLAVE_PACKET_SET_WATCHDOG_FAIL_REQ_T;
/** type of <code>CANOPEN_SLAVE_PACKET_SET_WATCHDOG_FAIL_CNF_Ttag</code> */
typedef struct CANOPEN_SLAVE_PACKET_SET_WATCHDOG_FAIL_CNF_Ttag
  CANOPEN_SLAVE_PACKET_SET_WATCHDOG_FAIL_CNF_T;

__PACKED_PRE struct CANOPEN_SLAVE_PACKET_SET_WATCHDOG_FAIL_REQ_Ttag
{
  TLR_PACKET_HEADER_T tHead; /** packet header.            */

}__PACKED_POST;

__PACKED_PRE struct CANOPEN_SLAVE_PACKET_SET_WATCHDOG_FAIL_CNF_Ttag
{
  TLR_PACKET_HEADER_T tHead; /** packet header.            */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>CANOPEN_SLAVE_PACKET_SET_NMT_STATE_REQ_Ttag</code> */
typedef struct CANOPEN_SLAVE_PACKET_SET_NMT_STATE_REQ_Ttag
  CANOPEN_SLAVE_PACKET_SET_NMT_STATE_REQ_T;
/** type of <code>CANOPEN_SLAVE_PACKET_SET_NMT_STATE_CNF_Ttag</code> */
typedef struct CANOPEN_SLAVE_PACKET_SET_NMT_STATE_CNF_Ttag
  CANOPEN_SLAVE_PACKET_SET_NMT_STATE_CNF_T;

__PACKED_PRE struct CANOPEN_SLAVE_PACKET_SET_NMT_STATE_REQ_Ttag
{
  TLR_PACKET_HEADER_T                    tHead; /** packet header.            */
  CANOPEN_SLAVE_SET_NMT_STATE_REQ_DATA_T tData; /** packet data.              */

}__PACKED_POST;

__PACKED_PRE struct CANOPEN_SLAVE_PACKET_SET_NMT_STATE_CNF_Ttag
{
  TLR_PACKET_HEADER_T tHead;                    /** packet header.            */
  CANOPEN_SLAVE_SET_NMT_STATE_CNF_DATA_T tData; /** packet data.              */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>CANOPEN_SLAVE_PACKET_SET_EVENTS_INDICATED_REQ_Ttag</code> */
typedef struct CANOPEN_SLAVE_PACKET_SET_EVENTS_INDICATED_REQ_Ttag
  CANOPEN_SLAVE_PACKET_SET_EVENTS_INDICATED_REQ_T;
/** type of <code>CANOPEN_SLAVE_PACKET_SET_EVENTS_INDICATED_CNF_Ttag</code> */
typedef struct CANOPEN_SLAVE_PACKET_SET_EVENTS_INDICATED_CNF_Ttag
  CANOPEN_SLAVE_PACKET_SET_EVENTS_INDICATED_CNF_T;

__PACKED_PRE struct CANOPEN_SLAVE_PACKET_SET_EVENTS_INDICATED_REQ_Ttag
{
  TLR_PACKET_HEADER_T                           tHead; /** packet header. */
  CANOPEN_SLAVE_SET_EVENTS_INDICATED_REQ_DATA_T tData; /** packet data.   */

}__PACKED_POST;

__PACKED_PRE struct CANOPEN_SLAVE_PACKET_SET_EVENTS_INDICATED_CNF_Ttag
{
  TLR_PACKET_HEADER_T tHead;                         /** packet header. */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>CANOPEN_SLAVE_PACKET_SETUP_PDO_INDICATION_REQ_Ttag</code> */
typedef struct CANOPEN_SLAVE_PACKET_SETUP_PDO_INDICATION_REQ_Ttag
  CANOPEN_SLAVE_PACKET_SETUP_PDO_INDICATION_REQ_T;
/** type of <code>CANOPEN_SLAVE_PACKET_SETUP_PDO_INDICATION_CNF_Ttag</code> */
typedef struct CANOPEN_SLAVE_PACKET_SETUP_PDO_INDICATION_CNF_Ttag
  CANOPEN_SLAVE_PACKET_SETUP_PDO_INDICATION_CNF_T;

__PACKED_PRE struct CANOPEN_SLAVE_PACKET_SETUP_PDO_INDICATION_REQ_Ttag
{
  TLR_PACKET_HEADER_T                           tHead; /** packet header. */
  CANOPEN_SLAVE_SETUP_PDO_INDICATION_REQ_DATA_T tData; /** packet data.   */

}__PACKED_POST;

__PACKED_PRE struct CANOPEN_SLAVE_PACKET_SETUP_PDO_INDICATION_CNF_Ttag
{
  TLR_PACKET_HEADER_T tHead;                         /** packet header. */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>CANOPEN_SLAVE_PACKET_RECEIVE_PDO_IND_Ttag</code> */
typedef struct CANOPEN_SLAVE_PACKET_RECEIVE_PDO_IND_Ttag
  CANOPEN_SLAVE_PACKET_RECEIVE_PDO_IND_T;
/** type of <code>CANOPEN_SLAVE_PACKET_RECEIVE_PDO_RES_Ttag</code> */
typedef struct CANOPEN_SLAVE_PACKET_RECEIVE_PDO_RES_Ttag
  CANOPEN_SLAVE_PACKET_RECEIVE_PDO_RES_T;

__PACKED_PRE struct CANOPEN_SLAVE_PACKET_RECEIVE_PDO_IND_Ttag
{
  TLR_PACKET_HEADER_T                  tHead; /** packet header. */
  CANOPEN_SLAVE_RECEIVE_PDO_IND_DATA_T tData; /** packet data.   */

}__PACKED_POST; 

__PACKED_PRE struct CANOPEN_SLAVE_PACKET_RECEIVE_PDO_RES_Ttag
{
  TLR_PACKET_HEADER_T tHead;                  /** packet header. */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>CANOPEN_SLAVE_PACKET_SEND_TXPDO_REQ_Ttag</code> */
typedef struct CANOPEN_SLAVE_PACKET_SEND_TXPDO_REQ_Ttag
  CANOPEN_SLAVE_PACKET_SEND_TXPDO_REQ_T;
/** type of <code>CANOPEN_SLAVE_PACKET_SEND_TXPDO_CNF_Ttag</code> */
typedef struct CANOPEN_SLAVE_PACKET_SEND_TXPDO_CNF_Ttag
  CANOPEN_SLAVE_PACKET_SEND_TXPDO_CNF_T;

__PACKED_PRE struct CANOPEN_SLAVE_PACKET_SEND_TXPDO_REQ_Ttag
{
  TLR_PACKET_HEADER_T                 tHead; /** packet header. */
  CANOPEN_SLAVE_SEND_TXPDO_REQ_DATA_T tData; /** packet data.   */

}__PACKED_POST;

__PACKED_PRE struct CANOPEN_SLAVE_PACKET_SEND_TXPDO_CNF_Ttag
{
  TLR_PACKET_HEADER_T                 tHead; /** packet header. */
  CANOPEN_SLAVE_SEND_TXPDO_CNF_DATA_T tData; /** packet data.   */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>CANOPEN_SLAVE_PACKET_RECV_RXPDO_REQ_Ttag</code> */
typedef struct CANOPEN_SLAVE_PACKET_RECV_RXPDO_REQ_Ttag
  CANOPEN_SLAVE_PACKET_RECV_RXPDO_REQ_T;
/** type of <code>CANOPEN_SLAVE_PACKET_RECV_RXPDO_CNF_Ttag</code> */
typedef struct CANOPEN_SLAVE_PACKET_RECV_RXPDO_CNF_Ttag
  CANOPEN_SLAVE_PACKET_RECV_RXPDO_CNF_T;

__PACKED_PRE struct CANOPEN_SLAVE_PACKET_RECV_RXPDO_REQ_Ttag
{
  TLR_PACKET_HEADER_T                 tHead; /** packet header. */
  CANOPEN_SLAVE_RECV_RXPDO_REQ_DATA_T tData; /** packet data.   */

}__PACKED_POST;

__PACKED_PRE struct CANOPEN_SLAVE_PACKET_RECV_RXPDO_CNF_Ttag
{
  TLR_PACKET_HEADER_T                 tHead; /** packet header. */
  CANOPEN_SLAVE_RECV_RXPDO_CNF_DATA_T tData; /** packet data.   */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>CANOPEN_SLAVE_PACKET_RECV_RXPDO_IND_Ttag</code> */
typedef struct CANOPEN_SLAVE_PACKET_RECV_RXPDO_IND_Ttag
  CANOPEN_SLAVE_PACKET_RECV_RXPDO_IND_T;
/** type of <code>CANOPEN_SLAVE_PACKET_RECV_RXPDO_RES_Ttag</code> */
typedef struct CANOPEN_SLAVE_PACKET_RECV_RXPDO_RES_Ttag
  CANOPEN_SLAVE_PACKET_RECV_RXPDO_RES_T;

__PACKED_PRE struct CANOPEN_SLAVE_PACKET_RECV_RXPDO_IND_Ttag
{
  TLR_PACKET_HEADER_T                 tHead; /** packet header. */
  CANOPEN_SLAVE_RECV_RXPDO_IND_DATA_T tData; /** packet data.   */

}__PACKED_POST;

__PACKED_PRE struct CANOPEN_SLAVE_PACKET_RECV_RXPDO_RES_Ttag
{
  TLR_PACKET_HEADER_T tHead; /** packet header. */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>CANOPEN_SLAVE_PACKET_NMT_STATE_CHANGE_IND_Ttag</code> */
typedef struct CANOPEN_SLAVE_PACKET_NMT_STATE_CHANGE_IND_Ttag
  CANOPEN_SLAVE_PACKET_NMT_STATE_CHANGE_IND_T;
/** type of <code>CANOPEN_SLAVE_PACKET_NMT_STATE_CHANGE_RES_Ttag</code> */
typedef struct CANOPEN_SLAVE_PACKET_NMT_STATE_CHANGE_RES_Ttag
  CANOPEN_SLAVE_PACKET_NMT_STATE_CHANGE_RES_T;

__PACKED_PRE struct CANOPEN_SLAVE_PACKET_NMT_STATE_CHANGE_IND_Ttag
{
  TLR_PACKET_HEADER_T                       tHead; /** packet header. */
  CANOPEN_SLAVE_NMT_STATE_CHANGE_IND_DATA_T tData; /** packet data.   */

}__PACKED_POST;

__PACKED_PRE struct CANOPEN_SLAVE_PACKET_NMT_STATE_CHANGE_RES_Ttag
{
  TLR_PACKET_HEADER_T  tHead; /** packet header. */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>CANOPEN_SLAVE_PACKET_ERR_CTRL_EVENT_IND_Ttag</code> */
typedef struct CANOPEN_SLAVE_PACKET_ERR_CTRL_EVENT_IND_Ttag
  CANOPEN_SLAVE_PACKET_ERR_CTRL_EVENT_IND_T;
/** type of <code>CANOPEN_SLAVE_PACKET_NMT_STATE_CHANGE_RES_Ttag</code> */
typedef struct CANOPEN_SLAVE_PACKET_ERR_CTRL_EVENT_RES_Ttag
  CANOPEN_SLAVE_PACKET_ERR_CTRL_EVENT_RES_T;

__PACKED_PRE struct CANOPEN_SLAVE_PACKET_ERR_CTRL_EVENT_IND_Ttag
{
  TLR_PACKET_HEADER_T                     tHead; /** packet header. */
  CANOPEN_SLAVE_ERR_CTRL_EVENT_IND_DATA_T tData; /** packet data.   */

}__PACKED_POST;

__PACKED_PRE struct CANOPEN_SLAVE_PACKET_ERR_CTRL_EVENT_RES_Ttag
{
  TLR_PACKET_HEADER_T  tHead; /** packet header. */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>CANOPEN_SLAVE_PACKET_NMT_COMMAND_IND_Ttag</code> */
typedef struct CANOPEN_SLAVE_PACKET_NMT_COMMAND_IND_Ttag
 CANOPEN_SLAVE_PACKET_NMT_COMMAND_IND_T;
/** type of <code>CANOPEN_SLAVE_PACKET_NMT_COMMAND_RES_Ttag</code> */
typedef struct CANOPEN_SLAVE_PACKET_NMT_COMMAND_RES_Ttag
 CANOPEN_SLAVE_PACKET_NMT_COMMAND_RES_T;

__PACKED_PRE struct CANOPEN_SLAVE_PACKET_NMT_COMMAND_IND_Ttag
{
  TLR_PACKET_HEADER_T                  tHead; /** packet header. */
  CANOPEN_SLAVE_NMT_COMMAND_IND_DATA_T tData; /** packet data.   */

}__PACKED_POST;

__PACKED_PRE struct CANOPEN_SLAVE_PACKET_NMT_COMMAND_RES_Ttag
{
  TLR_PACKET_HEADER_T                  tHead; /** packet header. */
  CANOPEN_SLAVE_NMT_COMMAND_RES_DATA_T tData; /** packet data.   */

}__PACKED_POST;
/*************************************************************************************/

/*************************************************************************************/
/** type of <code>CANOPEN_SLAVE_PACKET_GET_BUSPARAM_REQ_Ttag</code> */
typedef struct CANOPEN_SLAVE_PACKET_GET_BUSPARAM_REQ_Ttag
  CANOPEN_SLAVE_PACKET_GET_BUSPARAM_REQ_T;
/** type of <code>CANOPEN_SLAVE_PACKET_GET_BUSPARAM_CNF_Ttag</code> */
typedef struct CANOPEN_SLAVE_PACKET_GET_BUSPARAM_CNF_Ttag
  CANOPEN_SLAVE_PACKET_GET_BUSPARAM_CNF_T;

/** Structure of task command get bus parameter request */
__PACKED_PRE struct CANOPEN_SLAVE_PACKET_GET_BUSPARAM_REQ_Ttag
{
  TLR_PACKET_HEADER_T tHead;  /** packet header.       */

}__PACKED_POST;

/** Structure of task comand get bus parameter confirmation */
struct CANOPEN_SLAVE_PACKET_GET_BUSPARAM_CNF_Ttag
{
  TLR_PACKET_HEADER_T                   tHead;  /** packet header. */
  CANOPEN_SLAVE_GET_BUSPARAM_CNF_DATA_T tData;  /** packet data.   */

}__PACKED_POST;
/*************************************************************************************/

/** @} */

/*************************************************************************************/

/* pragma unpack */
#ifdef PRAGMA_PACK_ENABLE
#pragma PRAGMA_UNPACK_1(__CANOPEN_SLAVE_PUBLIC)
#endif

#endif /* #ifndef __CANOPEN_SLAVE_PUBLIC_H */

/**************************************************************************************/
/*------------------------------------------------------------------------------------*/
/*---------------------------- EOF ---------------------------------------------------*/
/*------------------------------------------------------------------------------------*/
/**************************************************************************************/
